uniform float u_contrast;
uniform float u_brightness;
uniform float u_glowStrength;
varying vec2 v_texCoord;
varying vec2 v_diffTexCoord;
varying vec2 v_glowTexCoord;

void main()
{
    vec4 diffuse = texture2D(CC_Texture1, v_diffTexCoord);
 
    //screen
    vec4 colorOutput;

    colorOutput.rgb = diffuse.rgb;
    
    //contrast and brightness (from 0.0 to 1.0)
    colorOutput.rgb = (colorOutput.rgb - 0.5) * u_contrast + 0.5;
    colorOutput.rgb += u_brightness * 2.0 - 1.0;
    colorOutput.a = 1.0;
    gl_FragColor = colorOutput;
}
